function [Yss, Error] = SSFun(K,S,U)
Error = 0;
%Steady state for Bcatenin
%Input is [0-1]*(1+delta)
X30 = K.k4/K.k5*K.k6*K.GSK*(K.APC/K.K7)*(K.v14/K.k15)/K.kb6;
alpha = K.k9*X30/K.K8/K.k13;
gamma = K.v12/(K.k13*K.K17);

Sign = (1-gamma+alpha./(U))/abs(1-gamma+alpha./(U));
X11 = K.K17*(1-gamma+alpha./(U))/2.*(Sign*sqrt(1+4*gamma./(1-gamma+alpha./(U)).^2)-1);
X3 = (K.v12/X11-K.k13)*K.K8/K.k9;
X9 = 1/K.k10*X3*X11/K.K8*K.k9;
X10 = K.k10*X9/K.k11;
X15 = X11*K.APC/(K.K17+X11);
X14 = X11*K.TCF/(K.K16+X11);
X8 = X3*X11/K.K8;

Yss = [X3 X8 X9 X10 X11 X14 X15];
%Yss = 
%1. APC*/Axin*/GSK3, 
%2. Bcatenin/APC*/Axin*/GSK3,
%3. Bcatenin*/APC*/Axin*/GSK3, 
%4. Bcatenin*, 
%5. Bcatenin, 
%6. Bcatenin/TCF, 
%7. Bcatenin/APC